Attribute VB_Name = "SomeModels"
'       This is a part of the source code for Pro/DESKTOP.
'       Copyright (C) 1999 Parametric Technology Corporation.
'       All rights reserved.


Function menuCreatePolygon()

'Visual Basic example  to create a polygon
'for a given number of sides and of a specified length

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

If activePart Is Nothing Then
    MsgBox "Could not get the Active Part", vbExclamation, "Error"
    Exit Function
End If

Dim numberOfSides As String               'Define variable used to hold the Number of sides of the polygon
Dim lengthOfSide As String                  'Define variable used to hold the Number of sides of the polygon
Dim number As Integer
Dim length As Double

'Get the User input for the number of sides and the length of the side.

numberOfSides = InputBox("Please enter the Number of Sides of the Polygon", "Number of sides")   'Get the Value of the number of sides from the user

If (IsNumeric(numberOfSides)) Then
    
    tempnumber = CDbl(numberOfSides)
    If (tempnumber = Int(tempnumber)) Then
        number = CInt(numberOfSides)
        
        If (number <= 2) Then
            MsgBox ("The Number of Sides should be greater than 2")
            Exit Function
        End If
    
        lengthOfSide = InputBox("Please enter the length of side of the poloygon in mm", "Length of Side")    'Get the Value of the length of the side from the user
    
        If (IsNumeric(lengthOfSide)) Then
            
            length = CDbl(lengthOfSide)
            If (lengthOfSide <= 0) Then
            MsgBox ("The Length of a side should be greater than zero  ")
            Exit Function
            End If
    
            CreatePolygon number, length / 1000
            
        Else
        MsgBox "The value entered is not a valid number"
        Exit Function
        End If
    Else
    MsgBox "The number of sides has to be an integer"
    Exit Function
    End If
  
Else
    MsgBox "The value entered is not a valid number"
    Exit Function
End If

api.CommitCalls "CreatePolygon", pause

End Function

Sub CreatePolygon(numberOfSides As Integer, lengthOfSide As Double)

' Subroutine to create a polygon given the length and number of sides of
' of the polygon.

' Create the polygon on the Active sketch.
' Origin for the polygon is (0,0)

' Draws the first line by using the length value and assuming angle to be zero.
' Subsequent lines are drawn using cosine and sine of the exterior angle for the
' polygon.

'Dim ProDESKTOP As Object          'Define variable used to hold the ProDESKTOP object
'Dim part As PartDocument          'Define variable used to hold the PartDocument object



Const pause As Boolean = False

'Connect to the ProDESKTOP Application object.
Set prod = CreateObject("ProDESKTOP.Application")
    
If prod Is Nothing Then        'Exit if no ProDESKTOP Application Object is created.
    MsgBox ("Could not create the ProDESKTOP Application Object")
    Exit Sub
End If

prod.SetVisible (True)                'Make the ProDESKTOP Application Visible.

'Exit if no Part document is active
On Error GoTo NoDocErr
Set part = prod.NewPart()        'Get the active document
On Error GoTo 0

'Create an Object Set
Dim obset1 As ObjectSet
Set obset1 = prod.GetClass("ObjectSet").CreateAObjectSet

  
'Initialize the starting vectors
Let startx = 0#
Let starty = 0#
Let startz = 0#

'Create the first vector
Dim firstVector  As zVector
Set firstVector = prod.GetClass("Vector").CreateVector(startx, starty, startz)

'Set the initial value for the Angle
Let pAngle = 0

'Set the initial values of x1,y1,z1
Let X1 = startx
Let Y1 = starty
Let z1 = startz

For I = 1 To (numberOfSides - 1)

    'Create a vector using the x1,y1,z1 values
    Dim vector1  As zVector
    Set vector1 = prod.GetClass("Vector").CreateVector(X1, Y1, z1)
    
    'Set the x2 coordinate  using the Cosine of the Angle and the Length of the side
    'Set the y2 coordinate  using the Sine of the Angle and the Length of the side
    
    X2 = X1 + lengthOfSide * Cos(pAngle)
    Y2 = Y1 + lengthOfSide * Sin(pAngle)
    z2 = 0#
    
    'Create a vector using the x2,y2,z2 values
    Dim vector2  As zVector
    Set vector2 = prod.GetClass("Vector").CreateVector(X2, Y2, z2)
    
    'Use the Function CreateLine(startPt As ZVector, endPt As ZVector)
    'to create a line between the two given vectors
    
    Dim line As aLine
    Set line = CreateLine(vector1, vector2)
    
    'Add the line to the object set
    obset1.AddMember line
    
    'Set the angle using the following formula
    pAngle = pAngle + 2 * 3.1415 / numberOfSides
    
    'Set the x1,y1,z1 values for the next iteration
    
    Let X1 = X2
    Let Y1 = Y2
    Let z1 = z2

Next I                          'End Loop

'Create a Line using the CreateLine function between the last vector
'and the first vector in order to close the polygon

Dim lastLine As aLine
Set lastLine = CreateLine(vector2, firstVector)

'Add the last line to the object set
obset1.AddMember lastLine

'Get the Active Workplane
Dim wp As aWorkplane
Set wp = part.GetActiveWorkplane

'Use the AutoConstrain API to constrain the line set.
wp.AutoConstrain obset1

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub
        
 
End Sub



Function CreateLine(startPt As zVector, endPt As zVector)

'Get the Active Skecth and its parent workplane

Dim part As PartDocument          'Define variable used to hold the PartDocument object

'Connect to the ProDESKTOP Application object.
 
If prod Is Nothing Then        'Exit if no ProDESKTOP Application Object is created.
    MsgBox ("Could not create the ProDESKTOP Application Object")
    Exit Function
End If

Set part = prod.GetActiveDoc()        'Get the active part document

If part Is Nothing Then                     'Exit if no Part document is active
    MsgBox ("Could not get the Part Object")
    Exit Function
End If

Dim Sketch As aSketch
Set Sketch = part.GetActiveSketch
Dim plane As aWorkplane
Set plane = Sketch.GetParent("Workplane")

Dim startPoint As zVector
Dim endPoint As zVector

Dim localStart As zVector
Dim localEnd As zVector

'Get the local start and end vectors for the active workplane
Set localStart = plane.Get3DVector(startPt)
Set localEnd = plane.Get3DVector(endPt)

'Create a zCurve
Dim curve1 As zCurve
Set curve1 = prod.GetClass("BasicStraight").CreateBasicStraightTwoPoints(localStart, localEnd)

'Create a line by passing the zCurve
Dim line1 As aLine
Set line1 = Sketch.CreateLine(curve1)

'Use the AutoConstrain API to constrain the line.
'plane.AutoConstrain line1

Set CreateLine = line1

End Function


'VBA script to create wheel

Sub wheel()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

Dim part As PartDocument
Set part = prod.NewPart

'Get Ac tive workplane and sketch
Dim ActiveWorkplane As aWorkplane
Set ActiveWorkplane = part.GetActiveWorkplane
ActiveWorkplane.SetName ("Profile")
Set Profile = part.GetActiveSketch

'Create Profile

Dim vector1 As zVector
Dim vector2 As zVector
Dim vector3 As zVector
Dim vector4 As zVector
Dim vector5 As zVector
Dim vector6 As zVector
Dim vector7 As zVector
Dim vector8 As zVector
Dim vector9 As zVector
Dim vector10 As zVector
Dim vector11 As zVector
Dim vector12  As zVector
Dim Vector13 As zVector
Dim Vector14 As zVector


Set vector1 = prod.GetClass("Vector").CreateVector(-0.07915, 0.0625, 0#)
Set vector2 = prod.GetClass("Vector").CreateVector(-0.07915, 0.0815, 0#)
Set vector3 = prod.GetClass("Vector").CreateVector(-0.0125, 0.105, 0#)
Set vector4 = prod.GetClass("Vector").CreateVector(-0.0125, 0.155, 0#)
Set vector5 = prod.GetClass("Vector").CreateVector(-0.069, 0.1725, 0#)
Set vector6 = prod.GetClass("Vector").CreateVector(-0.069, 0.1875, 0#)
Set vector7 = prod.GetClass("Vector").CreateVector(0.069, 0.1875, 0#)
Set vector8 = prod.GetClass("Vector").CreateVector(0.069, 0.1725, 0#)
Set vector9 = prod.GetClass("Vector").CreateVector(0.0125, 0.155, 0#)
Set vector10 = prod.GetClass("Vector").CreateVector(0.0125, 0.105, 0#)
Set vector11 = prod.GetClass("Vector").CreateVector(0.07915, 0.0815, 0#)
Set vector12 = prod.GetClass("Vector").CreateVector(0.07915, 0.0625, 0#)
Set Vector13 = prod.GetClass("Vector").CreateVector(-0.1, 0#, 0#)
Set Vector14 = prod.GetClass("Vector").CreateVector(0.1, 0#, 0#)

Set line1 = line(vector1, vector2, Profile)
Set line2 = line(vector2, vector3, Profile)
Set line3 = line(vector3, vector4, Profile)
Set line4 = line(vector4, vector5, Profile)
Set line5 = line(vector5, vector6, Profile)
Set line6 = line(vector6, vector7, Profile)
Set line7 = line(vector7, vector8, Profile)
Set line8 = line(vector8, vector9, Profile)
Set line9 = line(vector9, vector10, Profile)
Set line10 = line(vector10, vector11, Profile)
Set line11 = line(vector11, vector12, Profile)
Set line12 = line(vector12, vector1, Profile)

'Create a new sketch for the axis

Dim Axis As aSketch
Set Axis = ActiveWorkplane.CreateSketch("axis")
Set line13 = line(Vector13, Vector14, Axis)
 
'Revolve profile
Dim revolution1 As aRevolution
Set revolution1 = prod.GetClass("Revolution").CreateRevolution(part.GetDesign, Profile, Axis, 6.28, 0, 0, 1, 0)
revolution1.SetName ("Wheel")
part.UpdateDesign
 
api.CommitCalls "Wheel", pause

Rem Save the Assembly
pathName = "c:\wheel.des"

On Error GoTo SaveErr
ret = part.Close(pathName, True)
On Error GoTo 0

Exit Sub

SaveErr:
        MsgBox "Could not Save the Active Part", vbExclamation, "Error"
        Exit Sub
        
End Sub



Function line(vector1, vector2, Sketch)

Dim curve As zCurve
Set curve = prod.GetClass("BasicStraight").CreateBasicStraightTwoPoints(vector1, vector2)
Set line = Sketch.CreateLine(curve)

End Function


'Sub Spindle.
'Creates a spindle for the spindle wheel assembly.

Sub spindle()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

Dim part As PartDocument
Set part = prod.NewPart

Dim Workplane As aWorkplane
Dim Workplane1 As aWorkplane
Dim Sketch As aSketch

Set Workplane = part.GetActiveWorkplane
Set Sketch = part.GetActiveSketch


Dim line1 As aLine
Dim line2 As aLine
Dim line3 As aLine
Dim line4 As aLine
Dim line5 As aLine
Dim line6 As aLine
Dim line7 As aLine
Dim line8 As aLine
Dim line13 As aLine
Dim line14 As aLine

Dim vector1 As zVector
Dim vector2 As zVector
Dim vector3 As zVector
Dim vector4 As zVector
Dim vector5 As zVector
Dim vector6 As zVector
Dim vector7 As zVector
Dim vector8 As zVector
Dim vector9 As zVector
Dim vector10 As zVector
Dim vector11 As zVector
Dim vector12  As zVector
Dim Vector13 As zVector
Dim Vector14 As zVector


Set vector1 = prod.GetClass("Vector").CreateVector(-0.15, 0.02, 0#)
Set vector2 = prod.GetClass("Vector").CreateVector(-0.15, 0.0375, 0#)
Set vector3 = prod.GetClass("Vector").CreateVector(-0.07915, 0.0375, 0#)
Set vector4 = prod.GetClass("Vector").CreateVector(-0.07915, 0.0625, 0#)
Set vector5 = prod.GetClass("Vector").CreateVector(0.07915, 0.0625, 0#)
Set vector6 = prod.GetClass("Vector").CreateVector(0.07915, 0.0375, 0#)
Set vector7 = prod.GetClass("Vector").CreateVector(0.15, 0.0375, 0#)
Set vector8 = prod.GetClass("Vector").CreateVector(0.15, 0.02, 0#)

'Create profile
 Set line1 = line(vector1, vector2, Sketch)
 Set line2 = line(vector2, vector3, Sketch)
 Set line3 = line(vector3, vector4, Sketch)
 Set line4 = line(vector4, vector5, Sketch)
 Set line5 = line(vector5, vector6, Sketch)
 Set line6 = line(vector6, vector7, Sketch)
 Set line7 = line(vector7, vector8, Sketch)
 Set line8 = line(vector8, vector1, Sketch)
 
'Create New sketch
Dim axisSketch As aSketch
sketchName = "axisSketch"
Set axisSketch = Workplane.CreateSketch(sketchName)

Set Vector13 = prod.GetClass("Vector").CreateVector(-0.1, 0#, 0#)
Set Vector14 = prod.GetClass("Vector").CreateVector(0.1, 0#, 0#)
Set line13 = line(Vector13, Vector14, axisSketch)

'Create Revolution
'Revolve profile
 
Dim revolution1 As aRevolution
 
'THis script assumes that 0 indicates Add Material, 1 for subtrace and 2 for intersect
 
Set revolution1 = prod.GetClass("Revolution").CreateRevolution(part.GetDesign, Sketch, axisSketch, 6.28, 0, 0, 1, 0)
revolution1.SetName ("Spindle")
part.UpdateDesign

api.CommitCalls "Spindle", pause

Rem Save the Assembly
pathName = "c:\spindle.des"

On Error GoTo SaveErr
ret = part.Close(pathName, True)
On Error GoTo 0

Exit Sub

SaveErr:
        MsgBox "Could not Save the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub SidePlate()

    Dim app As Object
    Set app = CreateObject("ProDESKTOP.Application")
    
    'Take the helm
    Dim api As helm
    Set api = app.TakeHelm
    
    Dim part As PartDocument
    Set part = app.NewPart()
    
    Dim design As aDesign
    Set design = part.GetDesign
    
    Dim workplaneSet As ObjectSet
    Set workplaneSet = design.GetWorkplanes
    
    Dim Frontalworkplane As aWorkplane
    
    Dim baseworkplane As aWorkplane
    Dim lateralworkplane As aWorkplane
    
    Set baseworkplane = part.LookupWorkplane("base")
    Set Frontalworkplane = part.LookupWorkplane("frontal")
    Set lateralworkplane = part.LookupWorkplane("lateral")
    
    Set Sketch = Frontalworkplane.CreateSketch("BasicSketch")
    part.SetActiveSketch Sketch
    
    Set Sketch = part.GetActiveSketch
    
    Dim vector1 As zVector
    Dim vector2 As zVector
    Dim vector3 As zVector
    Dim vector4 As zVector
    Dim vector5 As zVector
    Dim vector6 As zVector
    Dim vector7 As zVector
    Dim vector8 As zVector
    Dim vector9 As zVector
    Dim vector10 As zVector
    Dim vector11 As zVector
    Dim vector12 As zVector
    
    Set vector1 = app.GetClass("Vector").CreateVector(-0.024, 0, 0.08)
    Set vector2 = app.GetClass("Vector").CreateVector(0.0385, 0, 0.08)
    Set vector3 = app.GetClass("Vector").CreateVector(0.0385, 0, -0.083)
    Set vector4 = app.GetClass("Vector").CreateVector(0.026, 0, -0.083)
    Set vector5 = app.GetClass("Vector").CreateVector(0.026, 0, -0.2685)
    Set vector6 = app.GetClass("Vector").CreateVector(0.1035, 0, -0.2685)
    Set vector7 = app.GetClass("Vector").CreateVector(0.1035, 0, -0.306)
    Set vector8 = app.GetClass("Vector").CreateVector(-0.0465, 0, -0.306)
    Set vector9 = app.GetClass("Vector").CreateVector(-0.0465, 0, -0.2685)
    Set vector10 = app.GetClass("Vector").CreateVector(-0.0115, 0, -0.2685)
    Set vector11 = app.GetClass("Vector").CreateVector(-0.0115, 0, -0.083)
    Set vector12 = app.GetClass("Vector").CreateVector(-0.024, 0, -0.083)
    
    Dim curve1 As zCurve
    Dim curve2 As zCurve
    Dim curve3 As zCurve
    Dim curve4 As zCurve
    Dim curve5 As zCurve
    Dim curve6 As zCurve
    Dim curve7 As zCurve
    Dim curve8 As zCurve
    Dim curve9 As zCurve
    Dim curve10 As zCurve
    Dim curve11 As zCurve
    Dim curve12 As zCurve
    
    Dim line1 As aLine
    Dim line2 As aLine
    Dim line3 As aLine
    Dim line4 As aLine
    Dim line5 As aLine
    Dim line6 As aLine
    Dim line7 As aLine
    Dim line8 As aLine
    Dim line9 As aLine
    Dim line10 As aLine
    Dim line11 As aLine
    Dim line12 As aLine
    
    Set curve1 = app.GetClass("BasicStraight").CreateBasicStraightTwoPoints(vector1, vector2)
    Set line1 = Sketch.CreateLine(curve1)
    
    Set curve2 = app.GetClass("BasicStraight").CreateBasicStraightTwoPoints(vector2, vector3)
    Set line2 = Sketch.CreateLine(curve2)
    
    Set curve3 = app.GetClass("BasicStraight").CreateBasicStraightTwoPoints(vector3, vector4)
    Set line3 = Sketch.CreateLine(curve3)
    
    Set curve4 = app.GetClass("BasicStraight").CreateBasicStraightTwoPoints(vector4, vector5)
    Set line4 = Sketch.CreateLine(curve4)
    
    Set curve5 = app.GetClass("BasicStraight").CreateBasicStraightTwoPoints(vector5, vector6)
    Set line5 = Sketch.CreateLine(curve5)
    
    Set curve6 = app.GetClass("BasicStraight").CreateBasicStraightTwoPoints(vector6, vector7)
    Set line6 = Sketch.CreateLine(curve6)
    
    Set curve7 = app.GetClass("BasicStraight").CreateBasicStraightTwoPoints(vector7, vector8)
    Set line7 = Sketch.CreateLine(curve7)
    
    Set curve8 = app.GetClass("BasicStraight").CreateBasicStraightTwoPoints(vector8, vector9)
    Set line8 = Sketch.CreateLine(curve8)
    
    Set curve9 = app.GetClass("BasicStraight").CreateBasicStraightTwoPoints(vector9, vector10)
    Set line9 = Sketch.CreateLine(curve9)
    
    Set curve10 = app.GetClass("BasicStraight").CreateBasicStraightTwoPoints(vector10, vector11)
    Set line10 = Sketch.CreateLine(curve10)
    
    Set curve11 = app.GetClass("BasicStraight").CreateBasicStraightTwoPoints(vector11, vector12)
    Set line11 = Sketch.CreateLine(curve11)
    
    Set curve12 = app.GetClass("BasicStraight").CreateBasicStraightTwoPoints(vector12, vector1)
    Set line12 = Sketch.CreateLine(curve12)
    
    'Create Extrusion1
    Dim extrusion1 As aOperation
    Set extrusion1 = app.GetClass("Extrusion").CreateExtrusion(part.GetDesign, Sketch, 0.2, 0, 0, 0, 1, 0)
    extrusion1.SetName "Extrusion1"
    part.UpdateDesign
    
    part.SetState (5)
    
    Dim FaceSet As ObjectSet
    Set FaceSet = design.GetFacesOfOperation(extrusion1)
    
    Dim faceSetIt As iterator
    Set faceSetIt = app.GetClass("it").CreateAObjectIt(FaceSet)
    
    Set face0 = faceSetIt.start
    Set face1 = faceSetIt.Next
    Set face2 = faceSetIt.Next
    Set face3 = faceSetIt.Next
    Set face4 = faceSetIt.Next
    Set face5 = faceSetIt.Next
    
    Set face6 = faceSetIt.Next
    Set face7 = faceSetIt.Next
    Set face8 = faceSetIt.Next
    Set face9 = faceSetIt.Next
    Set face10 = faceSetIt.Next
    
    part.SetSelection face10
    
    'Create a Workplane dspaceWp2
      
    Dim geom As zGeometry
    Set geom = face10.GetGeometricForm
    
    Dim Topyplane As zPlane
    Set Topyplane = geom
    
    Dim refplane2 As aWorkplane
    Set refplane2 = part.GetDesign.CreateWorkplane(Topyplane, "dspaceWP2")
    
    Dim Hole1 As aSketch
    Set Hole1 = refplane2.CreateSketch("ProfileSketch")
    
    part.SetActiveSketch Hole1
    
    Set vector1 = app.GetClass("Vector").CreateVector(0, 0#, 0)
    Set localcenter1 = part.GetActiveWorkplane.Get3DVector(vector1)
    
    Dim Plane3 As zPlane
    Set Plane3 = part.GetActiveWorkplane.GetGeometry
    Dim radius As Double
    
    radius = 0.05265
    Dim curve100 As zBasicCircle
    Set curve100 = app.GetClass("BasicCircle").CreateBasicCircle(localcenter1, Plane3.GetNormal, radius)
    
    part.SetState 1
    Dim circle1 As aLine
    Set circle1 = part.GetActiveSketch.CreateLine(curve100)
    
    Dim face100 As ObjectSet
    Dim projection3 As aOperation
    Set faceSet2 = app.GetClass("ObjectSet").CreateAObjectSet
    Set projection3 = app.GetClass("Projection").CreateProjection(part.GetDesign, part.GetActiveSketch, faceSet2, 1, 1, 0, 0, 2, 0)
    projection3.SetName "Projection1"
    part.UpdateDesign
    
    Dim profileWorkplane As aWorkplane
    Dim ProfileSketch As aSketch
    Set profileWorkplane = part.GetActiveWorkplane
    
    Set ProfileSketch = part.GetActiveWorkplane.CreateSketch("NewSketch")
    part.SetActiveSketch ProfileSketch
    
    Set vector1 = app.GetClass("Vector").CreateVector(-0.1, -0.267, 0)
    Set localvector1 = part.GetActiveWorkplane.Get3DVector(vector1)
    
    Set vector2 = app.GetClass("Vector").CreateVector(-0.1, 0.0815, 0)
    Set localvector2 = part.GetActiveWorkplane.Get3DVector(vector2)
    
    Set vector3 = app.GetClass("Vector").CreateVector(0#, 0.0815, 0)
    Set localvector3 = part.GetActiveWorkplane.Get3DVector(vector3)
    
    Set vector4 = app.GetClass("Vector").CreateVector(-0.081309063993, 0.005575492132, 0)
    Set localvector4 = part.GetActiveWorkplane.Get3DVector(vector4)
    
    Set curve1 = app.GetClass("BasicStraight").CreateBasicStraightTwoPoints(localvector1, localvector2)
    Set line1 = part.GetActiveSketch.CreateLine(curve1)
    
    
    Dim newlineset As ObjectSet
    Set newlineset = part.GetActiveSketch.GetLines(True, True)
    
    newlineset.AddMember line1
    
    Set curve2 = app.GetClass("BasicStraight").CreateBasicStraightTwoPoints(localvector2, localvector3)
    Set line2 = part.GetActiveSketch.CreateLine(curve2)
    
    newlineset.AddMember line2
    
    Dim curve400 As zBasicCircularArc
    Set vector5 = app.GetClass("Vector").CreateVector(0, 0, 0)
    Set localcenter5 = part.GetActiveWorkplane.Get3DVector(vector5)
    Dim plane5 As zPlane
    Set plane5 = part.GetActiveWorkplane.GetGeometry
    Set curve400 = app.GetClass("BasicCircularArc").CreateBasicCircularArc(localcenter5, plane5.GetNormal, 0.0815, localvector3, localvector4)
    Dim Circle4 As aLine
    Set Circle4 = part.GetActiveSketch.CreateLine(curve400)
    
    newlineset.AddMember Circle4
    
    Set curve4 = app.GetClass("BasicStraight").CreateBasicStraightTwoPoints(localvector4, localvector1)
    Set line4 = part.GetActiveSketch.CreateLine(curve4)
    
    newlineset.AddMember line4
    
    Dim projection5 As aOperation
    Set projection5 = app.GetClass("Projection").CreateProjection(part.GetDesign, part.GetActiveSketch, faceSet2, 1, 1, 0, 0, 2, 0)
    projection5.SetName "Projection5"
    part.UpdateDesign
    
    Set profile2 = part.GetActiveWorkplane.CreateSketch("profile2")
    part.SetActiveSketch profile2
    
    Set mvector1 = app.GetClass("Vector").CreateVector(0.1, -0.267, 0)
    Set mlocalvector1 = part.GetActiveWorkplane.Get3DVector(mvector1)
    Set mvector2 = app.GetClass("Vector").CreateVector(0.1, 0.0815, 0)
    Set mlocalvector2 = part.GetActiveWorkplane.Get3DVector(mvector2)
    Set mvector3 = app.GetClass("Vector").CreateVector(0#, 0.0815, 0)
    Set mlocalvector3 = part.GetActiveWorkplane.Get3DVector(mvector3)
    Set mvector4 = app.GetClass("Vector").CreateVector(0.081309063993, 0.005575492132, 0)
    Set mlocalvector4 = part.GetActiveWorkplane.Get3DVector(mvector4)
    
    Set mcurve1 = app.GetClass("BasicStraight").CreateBasicStraightTwoPoints(mlocalvector1, mlocalvector2)
    Set mline1 = part.GetActiveSketch.CreateLine(mcurve1)
    
    Set mcurve2 = app.GetClass("BasicStraight").CreateBasicStraightTwoPoints(mlocalvector2, mlocalvector3)
    Set mline2 = part.GetActiveSketch.CreateLine(mcurve2)
    
    Dim mcurve400 As zBasicCircularArc
    Set mvector5 = app.GetClass("Vector").CreateVector(0, 0, 0)
    Set mlocalcenter5 = part.GetActiveWorkplane.Get3DVector(mvector5)
    Dim mplane5 As zPlane
    Set mplane5 = part.GetActiveWorkplane.GetGeometry
    Set mcurve400 = app.GetClass("BasicCircularArc").CreateBasicCircularArc(mlocalcenter5, mplane5.GetNormal.GetNegative.GetDirection, 0.0815, mlocalvector3, mlocalvector4)
    Dim mCircle4 As aLine
    Set mCircle4 = part.GetActiveSketch.CreateLine(mcurve400)
    
    Set mcurve4 = app.GetClass("BasicStraight").CreateBasicStraightTwoPoints(mlocalvector4, mlocalvector1)
    Set mline4 = part.GetActiveSketch.CreateLine(mcurve4)
    
    Dim projection6 As aOperation
    Set projection6 = app.GetClass("Projection").CreateProjection(part.GetDesign, part.GetActiveSketch, faceSet2, 1, 1, 0, 0, 2, 0)
    projection6.SetName "Projection6"
    part.UpdateDesign
    
    part.SetState (5)
       
    part.SetSelection face7
    
    Dim geom2 As zGeometry
    Set geom2 = face7.GetGeometricForm
    
    Dim Topyplane2 As zPlane
    Set Topyplane2 = geom2
    
    Dim refplane3 As aWorkplane
    Set refplane3 = part.GetDesign.CreateWorkplane(Topyplane2, "dspaceWP3")
    
    Dim Hole2 As aSketch
    Set Hole2 = refplane3.CreateSketch("ProfileSketch2")
    part.SetActiveSketch Hole2
    
    Set vector1 = app.GetClass("Vector").CreateVector(0#, -0.07, 0)
    Set localcenter1 = part.GetActiveWorkplane.Get3DVector(vector1)
    
    Set vector2 = app.GetClass("Vector").CreateVector(0#, 0.07, 0)
    Set localcenter2 = part.GetActiveWorkplane.Get3DVector(vector2)
    
    Dim Plane9 As zPlane
    Set Plane9 = part.GetActiveWorkplane.GetGeometry
    
    Set curve9 = app.GetClass("BasicCircle").CreateBasicCircle(localcenter1, Plane9.GetNormal, 0.0125)
    Dim Circle2 As aLine
    Set Circle2 = part.GetActiveSketch.CreateLine(curve9)
    
    Set curve3 = app.GetClass("BasicCircle").CreateBasicCircle(localcenter2, Plane9.GetNormal, 0.0125)
    Dim Circle3 As aLine
    Set Circle3 = part.GetActiveSketch.CreateLine(curve3)
    
    Dim projection400 As aOperation
    Set projection400 = app.GetClass("Projection").CreateProjection(part.GetDesign, part.GetActiveSketch, faceSet2, 1, 1, 0, 0, 2, 0)
    projection400.SetName "Projection10"
    part.UpdateDesign
    
    api.CommitCalls "SupportPlate", pause

End Sub






